<?php

/*++++++++++++++++++++++++++++++++++++++++

  Script: Maian Gallery v2.0
  Written by: David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: http://www.maianscriptworld.co.uk

  ++++++++++++++++++++++++++++++++++++++++
  
  This File: index.php
  Description: Main Parsing File

  ++++++++++++++++++++++++++++++++++++++++*/

session_start();

// Set error reporting level..E_ALL for development...
error_reporting(0);

// Set paths/options..
define ('FOLDER_PATH', dirname(__FILE__).'/');
define ('PARENT',1);

// Load include files/classes..
include(FOLDER_PATH.'inc/db_connection.inc.php');
include(FOLDER_PATH.'inc/defined.inc.php');
include(FOLDER_PATH.'inc/functions.php');
include(FOLDER_PATH.'lib/Savant2.php');
include(FOLDER_PATH.'classes/class_generic.inc.php');
include(FOLDER_PATH.'classes/PaginateIt.php');
include(FOLDER_PATH.'classes/class_watermarker.inc.php');
include(FOLDER_PATH.'classes/class_slideshow.inc.php');
include(FOLDER_PATH.'classes/class_cart.inc.php');
include(FOLDER_PATH.'classes/class_rss.inc.php');
include(FOLDER_PATH.'classes/class_comments.inc.php');
include(FOLDER_PATH.'classes/class_paypal.inc.php');
include(FOLDER_PATH.'classes/class_mail.inc.php');
include(FOLDER_PATH.'inc/theme_attributes.php');

// Initialise settings..
// Load language file..
$SETTINGS = mysql_fetch_object(mysql_query("SELECT * FROM ".$database['prefix']."settings LIMIT 1")) or die(mysql_error());
include(FOLDER_PATH.'lang/'.$SETTINGS->language); 

// Define variables..
$cmd           = (isset($_GET['cmd']) ? strip_tags($_GET['cmd']) : 'home');
$meta_desc     = cleanData($SETTINGS->description);
$meta_keys     = cleanData($SETTINGS->keywords);
$theme         = (isset($_COOKIE['mgallery_theme_cookie']) ? $_COOKIE['mgallery_theme_cookie'] : ($SETTINGS->theme ? $SETTINGS->theme : 'standard'));
$title         = str_replace("{website}",cleanData($SETTINGS->website),$msg_header);
$page          = (isset($_GET['page']) ? strip_tags($_GET['page']) : '1');
$error_string  = array();
$count         = 0;
$limit         = $SETTINGS->thumbpage;
$limitvalue    = $page * $limit - ($limit); 
$find          = array();
$replace       = array();
$cryptinstall  = FOLDER_PATH.'captcha/cryptographp.fct.php';
include $cryptinstall;

// Check theme..
if ($theme && !is_dir(FOLDER_PATH.'themes/'.$theme)) {
  exit;
}

// If theme switcher is enabled and new theme has been set, reload..
if ($SETTINGS->themeswitcher && isset($_GET['load_theme'])) {
  updateGalleryTheme($_GET['load_theme']);
}

// Page var check..
checkDigit($page);
 
// Read paypal data into array..
$PP                     = paypal();

// Initialise classes..
$MGA_MAIL               = new mailClass();
$MGA_CART               = new mga_Cart();
$MGA_SLIDESHOW          = new mga_Slideshow();
$MGA_WMARK              = new waterMarker();
$MGA_COMMENTS           = new galleryComments();
$MGA_PAYPAL             = new paypalIPN((isset($_POST) ? $_POST : ''),$PP);
$MGA_FEED               = new rss_Feed();
$MGA_FEED->path         = $SETTINGS->folder.'/'.$theme.'/';
$MGA_CART->prefix       = $database['prefix'];
$MGA_CART->shipRate     = $PP->ppShipDefault;
$MGA_CART->shipSingle   = $PP->ppShipSingle;
$MGA_PAYPAL->prefix     = $database['prefix'];
$MGA_SLIDESHOW->prefix  = $database['prefix'];
$MGA_COMMENTS->prefix   = $database['prefix'];
$MGA_MAIL->smtp         = $SETTINGS->smtp;
$MGA_MAIL->smtp_host    = $SETTINGS->smtp_host;
$MGA_MAIL->smtp_user    = $SETTINGS->smtp_user;
$MGA_MAIL->smtp_pass    = $SETTINGS->smtp_pass;
$MGA_MAIL->smtp_port    = $SETTINGS->smtp_port;
$MGA_MAIL->addTag('{WEBSITE_NAME}',$SETTINGS->website);
$MGA_MAIL->addTag('{WEBSITE_URL}',$SETTINGS->folder);
$MGA_MAIL->addTag('{WEBSITE_EMAIL}',$SETTINGS->email);
$MGA_MAIL->addTag('{ADMIN_FOLDER}',ADMIN_FOLDER_NAME);

// Firstly, check ip address..
if (isIPAddressBanned($_SERVER['REMOTE_ADDR']) && $cmd!='contact') {
  $banned = true;
  include(FOLDER_PATH.'inc/header.php');
  showPageMessage($msg_script33);
  include(FOLDER_PATH.'inc/footer.php');
  exit;
}

// Clear comments that have not been verified..
clearDeadData();

// Main switch..
switch ($cmd)
{
  // Home/Paypal Cancel/Thanks..
  case 'home':
  case 'cancel':
  case 'thanks':
  case 'checkout':
  
  // Load message var for paypal cancel/thanks..
  if ($cmd=='cancel' || $cmd=='thanks') {
    $msg = str_replace("{url}",($SETTINGS->modr ? 'index.html' : 'index.php'),($cmd=='cancel' ? $msg_publichome7 : $msg_publichome8));
  }
  
  // Load field vars for checkout..
  // Only pass page style var if set, otherwise this might cause a paypal error..
  // Pass shipping if shipping is set..
  if ($cmd=='checkout') {
    // Generate invoice no..
    $invoice = $MGA_CART->getNextOrderID().rand(11,99).substr(time(),-5);
    
    // Create unique cart id..
    $cartID = $MGA_CART->random_data(32);
    
    // Log cart data...
    $MGA_CART->logCartData($invoice,$cartID);
    
    // Assign fields to send to paypal..
    $MGA_PAYPAL->add_field('rm', '2');
    $MGA_PAYPAL->add_field('cmd', '_xclick');
    $MGA_PAYPAL->add_field('business', $PP->ppEmail);
    $MGA_PAYPAL->add_field('item_name', $msg_publichome9);
    $MGA_PAYPAL->add_field('item_number', 'Pic-'.time());
    $MGA_PAYPAL->add_field('amount', $MGA_CART->cartTotal());
    $MGA_PAYPAL->add_field('notify_url', 'http'.($PP->ppSSL ? 's' : '').'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?cmd=notify');
    $MGA_PAYPAL->add_field('cancel_return', 'http'.($PP->ppSSL ? 's' : '').'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?cmd=cancel');
    $MGA_PAYPAL->add_field('return', 'http'.($PP->ppSSL ? 's' : '').'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?cmd=thanks');
    if ($PP->ppStyle) {
    $MGA_PAYPAL->add_field('page_style', $PP->ppStyle);
    }
    if ($MGA_CART->setShippingCharge()>0) {
    $MGA_PAYPAL->add_field('shipping', $MGA_CART->setShippingCharge());
    } else {
    $MGA_PAYPAL->add_field('no_shipping', 1);
    }
    $MGA_PAYPAL->add_field('currency_code', $PP->ppCurrency);
    $MGA_PAYPAL->add_field('custom', $cartID.'-'.$invoice.'-maiangallery');
    
    // Clear cart..
    $MGA_CART->clearCart();
    
    // Set message var..
    $msg = str_replace("{theme}",$theme,$msg_publichome10);
            
    // Set var to tell system to auto run form..
    $runForm = true;
  }
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_home = new Savant2();
  $tpl_home->assign('PAYPAL_FORM_DATA',(isset($runForm) ? $MGA_PAYPAL->loadHiddenFields() : ''));
  $tpl_home->assign('WELCOME',(isset($msg) ? '<span class="processed2">'.$msg.'</span>' : $msg_publichome4));
  $tpl_home->assign('WELCOME_TXT',$msg_header12);
  $tpl_home->assign('CATEGORIES_TEXT',$msg_adminmenu4);
  $tpl_home->assign('CATEGORIES', str_replace('{pictures}',loadGalleryCategories(),file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')));
  $tpl_home->assign('LATEST_PICS_TEXT', $msg_publichome6);
  $tpl_home->assign('LATEST_PICS', str_replace('{pictures}',loadStatPictures('id DESC',LATEST_PICS_LIMIT),file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')));
  $tpl_home->assign('MOST_VIEWED_TEXT', $msg_publichome);
  $tpl_home->assign('RANDOM_SELECTION_TEXT', $msg_publichome2);
  $tpl_home->assign('MOST_VIEWED', str_replace('{pictures}',loadStatPictures('visits DESC',MOST_VIEWED_LIMIT),file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')));
  $tpl_home->assign('RANDOM_SELECTION', str_replace('{pictures}',loadStatPictures('rand()',RANDOM_SELECTION_LIMIT),file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')));
  $tpl_home->assign('STATS',stats());
  $tpl_home->assign('STATS_TXT',$msg_publichome11);
  $tpl_home->display('themes/'.$theme.'/index.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Category..
  case 'category':
  
  // Security check on id..
  if (!isset($_GET['category'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
  }
  
  checkDigit($_GET['category']);
  
  // Load cat data into array..
  $cat        = getCategoryData($_GET['category']);
  $title      = $msg_category.': '.(!$cat->parent ? getCategoryName($cat->child).' - '.getCategoryName($_GET['category']) : getCategoryName($_GET['category']));
  $slideshow  = ''; 
  
  // Is category enabled..
  if (!$cat->en_cat) {
    header("Location: ".($SETTINGS->modr ? 'index.html' : 'index.php')."");
    exit;
  }
  
  // Are we overwriting default meta data?
  if ($cat->keywords) {
    $meta_keys = cleanData($cat->keywords);
  }
  if ($cat->description) {
    $meta_desc = cleanData($cat->description);
  }
   
  // Are slideshows enabled for this category?..
  if ($SETTINGS->slideshow && $cat->en_slideshow && getCategoryImageCount($_GET['category'])>0) {
    $find       = array('{view_slideshow}','{cat}','{pictures}','{url}','{theme}','{window_sizes}');
    $replace    = array($msg_category6,
                        getCategoryName($_GET['category']),
                        str_replace("{count}",getCategoryImageCount($_GET['category']),$msg_category7),
                        ($SETTINGS->modr ? 'slideshow/'.$_GET['category'].'/'.addTitleToUrl(getCategoryName($_GET['category'])).'/index.html' : 'index.php?cmd=slideshow&amp;category='.$_GET['category']),
                        $theme,
                        $SETTINGS->slidewindow);
    $slideshow  = str_replace($find,$replace,
                              file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/view_slideshow.tpl')
                              );
  } 
  
  // If we are viewing category, set session var so that we know what category
  //  we were viewing if the advanced search is loaded..
  $_SESSION['av_search_category'] = $_GET['category'];
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_category = new Savant2();
  $tpl_category->assign('MESSAGE',($cat->comments ? cleanData($cat->comments) : $msg_category2));
  $tpl_category->assign('HOME_URL',($SETTINGS->modr ? 'index.html' : 'index.php'));
  $tpl_category->assign('CATEGORIES',$msg_adminmenu4);
  $tpl_category->assign('CAT_URL',($SETTINGS->modr ? 'category/'.(!$cat->parent ? $cat->child : $_GET['category']).'/'.addTitleToUrl($cat->catname).'/index.html' : 'index.php?cmd=category&amp;category='.(!$cat->parent ? $cat->child : $_GET['category'])));
  $tpl_category->assign('SUB_CAT_URL',(!$cat->parent ? '<a href="'.($SETTINGS->modr ? 'category/'.$_GET['category'].'/'.addTitleToUrl($cat->catname).'/index.html' : 'index.php?cmd=category&amp;category='.$_GET['category']).'" title="'.getCategoryName($_GET['category']).'">'.getCategoryName($_GET['category']).'</a>' : ''));
  $tpl_category->assign('TOTAL_PICTURES',str_replace("{count}",getCategoryImageCount($_GET['category']),$msg_category7));
  $tpl_category->assign('CATEGORIES_TEXT',getCategoryName((!$cat->parent ? $cat->child : $_GET['category'])));
  $tpl_category->assign('PICTURES',str_replace('{pictures}',loadGalleryPictures($_GET['category'],$limit,'name',$limitvalue,false,'img',true),file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')));
  $tpl_category->assign('SUBCAT_TEXT',$msg_category3);
  $tpl_category->assign('SUB_CATEGORIES',displaySubCategoryLinks((!$cat->parent ? $cat->child : $_GET['category']),(!$cat->parent ? true : false),$cat->id));
  $tpl_category->assign('SUB_CATEGORIES_LIST',displaySubCategoryLinks((!$cat->parent ? $cat->child : $_GET['category']),(!$cat->parent ? true : false),$cat->id,$comma='list'));
  $tpl_category->assign('SUB_CATEGORIES_COMMA',displaySubCategoryLinks((!$cat->parent ? $cat->child : $_GET['category']),(!$cat->parent ? true : false),$cat->id,$comma=true));
  $tpl_category->assign('MOST_POPULAR_TEXT',$msg_category5);
  $tpl_category->assign('MOST_POPULAR', str_replace('{pictures}',loadStatPictures('visits DESC',MOST_VIEWED_LIMIT,$_GET['category']),file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')));
  $tpl_category->assign('LATEST_PICS_TEXT',$msg_category9);
  $tpl_category->assign('LATEST_PICS', str_replace('{pictures}',loadStatPictures('id DESC',LATEST_PICS_LIMIT,$_GET['category']),file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')));
  $tpl_category->assign('SLIDESHOW',$slideshow);
  $tpl_category->assign('OTHER',$msg_category12);
  $tpl_category->assign('SEARCH_TEXT',$msg_category11);
  $tpl_category->assign('SEARCH_URL',($SETTINGS->modr ? 'advanced-search.html' : 'index.php?cmd=advanced-search'));
  $tpl_category->assign('STATS',str_replace('{date}',dbSyntax('images','DATE_FORMAT(addDate,\''.$SETTINGS->mysql_date.'\') AS l_date','l_date',' WHERE cat = \''.$_GET['category'].'\' ORDER BY id DESC LIMIT 1'),$msg_category10));
  $tpl_category->assign('PAGE_NUMBERS',page_numbers(getCategoryImageCount($_GET['category']),$SETTINGS->thumbpage,$page,($SETTINGS->modr ? 'category/'.$_GET['category'].'/'.addTitleToUrl($cat->catname).'/{page}/index.html' : 'index.php?cmd=category&amp;category='.$_GET['category'].'&amp;page={page}')));
  $tpl_category->display('themes/'.$theme.'/category.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Pictures..
  case 'pictures':
  
  // Security check on id..
  if (!isset($_GET['picture'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
  }
  
  checkDigit($_GET['picture']);
  
  // Update image visit count..
  updateImageVisitCount($_GET['picture']);
  
  // Get image and category data..
  // Assign page title..
  $img       = getImageData($_GET['picture']);
  $cat       = getCategoryData($img->cat);
  $title     = $msg_pictures.': '.cleanData($img->name).' - '.cleanData($cat->catname);
  $fsize     = file_size_conversion($img->isize,BASE_SIZE_CALCULATION);
  $size      = array(0,0);
  $buyPics   = '';
  $comments  = '';
  
  // Are we overwriting default meta data?
  if ($img->keywords || $cat->keywords) {
    $meta_keys = $img->keywords ? cleanData($img->keywords) : cleanData($cat->keywords);
  }
  if ($img->description || $cat->description) {
    $meta_desc = $img->description ? cleanData($img->description) : cleanData($cat->description);
  }
  
  // Get actual dimensions of image, but only if image exists..
  if (file_exists('galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->imagepath)) {
    $size = getimagesize('galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->imagepath);
  }
  
  // Does this image have buy options enabled?
  if ($img->sale_item && $img->details && $SETTINGS->cart) {
    $find     = array('{buy_options}','{url}','{options}','{options_p}','{add_to_cart}');
    $replace  = array($msg_pictures12,
                      ($SETTINGS->modr ? 'add-to-cart.html' : 'index.php?cmd=add-to-cart'),
                      getBuyOptions($_GET['picture']),
                      getBuyOptions($_GET['picture'],true),
                      $msg_pictures13
                      );
    $buyPics  = str_replace($find,$replace,
                            file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/buy_pictures.tpl')
                            );
  }
  
  // Does this image have comment option enabled?
  if ($SETTINGS->comments && $cat->en_comments) {
    $comments = str_replace(array('{url}','{leave_comment}'),
                            array(($SETTINGS->modr ? 'comment/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=leave-comment&amp;picture='.$img->id),
                            $msg_pictures11
                            ),
                            file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/leave_comment.tpl')
                            );
  }
  
  // Overwrite limit vars for comments as they are different..
  $limit         = $SETTINGS->comthumbpage;
  $limitvalue    = $page * $limit - ($limit);
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_pictures = new Savant2();
  $tpl_pictures->assign('MESSAGE',($img->comments ? cleanData($img->comments) : $msg_pictures2));
  $tpl_pictures->assign('HOME_URL',($SETTINGS->modr ? 'index.html' : 'index.php'));
  $tpl_pictures->assign('CATEGORIES',$msg_adminmenu4);
  $tpl_pictures->assign('CAT_URL',($SETTINGS->modr ? 'category/'.(!$cat->parent ? $cat->child : $cat->id).'/'.addTitleToUrl($cat->catname).'/index.html' : 'index.php?cmd=category&amp;category='.$cat->id));
  $tpl_pictures->assign('CATEGORIES_TEXT',getCategoryName((!$cat->parent ? $cat->child : $cat->id)));
  $tpl_pictures->assign('IMAGE_INFO_TEXT',$msg_pictures3);
  $tpl_pictures->assign('COMMENTS_TEXT',$msg_pictures4.' ('.rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\'').')');
  $tpl_pictures->assign('PICTURE',cleanData($img->name));
  $tpl_pictures->assign('BIG_WINDOW', $SETTINGS->windowsizes);
  $tpl_pictures->assign('DATE_ADDED',str_replace("{date}",$img->i_date,$msg_pictures6));
  $tpl_pictures->assign('SIZES',str_replace(array('{width}','{height}'),array($size[0],$size[1]),$msg_pictures7));
  $tpl_pictures->assign('FILE_SIZE',str_replace("{size}",$fsize,$msg_pictures9));
  $tpl_pictures->assign('VIEWS',str_replace("{views}",number_format($img->visits),$msg_pictures8));
  $tpl_pictures->assign('PIC_URL',($SETTINGS->modr ? 'view-picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=view-picture&amp;picture='.$img->id));
  $tpl_pictures->assign('PICTURE_URL',($SETTINGS->watermarks && $cat->en_watermarks ? 'index.php?cmd=watermark&amp;picture='.$img->id : 'galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->imagepath));
  $tpl_pictures->assign('CLICK_FOR_FULLSIZE',$msg_pictures5);
  $tpl_pictures->assign('IMG_WIDTH',imgDisplaySize('galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->imagepath));
  $tpl_pictures->assign('IMG_HEIGHT',imgDisplaySize('galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->imagepath,'height'));
  $tpl_pictures->assign('HAVE_A_QUESTION',$msg_pictures10);
  $tpl_pictures->assign('Q_URL',($SETTINGS->modr ? 'question/'.$_GET['picture'].'/index.html' : 'index.php?cmd=ask-question&amp;picture='.$_GET['picture']));
  $tpl_pictures->assign('BUY_PICTURES',$buyPics);
  $tpl_pictures->assign('LEAVE_COMMENT',$comments);
  $tpl_pictures->assign('WINDOW',QUESTION_WINDOW_SIZE);
  $tpl_pictures->assign('COMMENTS',($SETTINGS->comments && $cat->en_comments ? (rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\'')>0 ? loadImageComments($_GET['picture'],$limitvalue,$SETTINGS->comthumbpage) : str_replace("{msg}",$msg_pictures15,file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/no_comments.tpl'))) : str_replace("{msg}",$msg_pictures16,file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/no_comments.tpl'))));
  $tpl_pictures->assign('COMMENT_PAGE_NUMBERS',($SETTINGS->comments && $cat->en_comments && rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\'')>0 ? page_numbers(rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\''),$SETTINGS->comthumbpage,$page,($SETTINGS->modr ? 'picture/'.$_GET['picture'].'/{page}/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&amp;picture='.$_GET['picture'].'&amp;page={page}'),'page_numbers_comments') : ''));
  $tpl_pictures->display('themes/'.$theme.'/picture.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Contact..
  case 'view-picture':
  
  // Security check on id..
  if (!isset($_GET['picture'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
  }
  
  checkDigit($_GET['picture']);
  
  // Get picture/category data..
  $img    = getImageData($_GET['picture']);
  $cat    = getCategoryData($img->cat);
  $title  = $msg_pictures.': '.cleanData($img->name).' - '.cleanData($cat->catname);
  
  $tpl_view_picture = new Savant2();
  $tpl_view_picture->assign('CHARSET',$msg_charset);
  $tpl_view_picture->assign('BASE_HREF',$SETTINGS->folder);
  $tpl_view_picture->assign('THEME',$theme);
  $tpl_view_picture->assign('TITLE', $title);
  $tpl_view_picture->assign('PIC_URL',($SETTINGS->watermarks && $cat->en_watermarks ? 'index.php?cmd=watermark&amp;picture='.$img->id : 'galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->imagepath));
  $tpl_view_picture->assign('NAME',cleanData($img->name));
  $tpl_view_picture->assign('WIDTH_HEIGHT',fullSizeDisplaySize());
  $tpl_view_picture->display('themes/'.$theme.'/full_size_image.tpl.php');
  
  break;
  
  // Comment..
  case 'leave-comment':
  case 'verify':
  
  // Are we verifying e-mail address?..
  if ($cmd=='verify') {
    // Split the code var..
    // Picture array var isn`t set initially, so set it..
    // Set code var for processing..
    $split            = explode("-",$_GET['code']);
    $_GET['picture']  = $split[0];
    $code             = $split[1];       
    
    // Is this a valid code..
    if (get_comment_data('',$_GET['code'],true)) {
      // Load comment data..
      $com = get_comment_data('',$_GET['code']);
      
      // Add email to allowed list..
      if (!$MGA_COMMENTS->isEmailVerified($com->email)) {
        // Add e-mail to database..
        $MGA_COMMENTS->addEmailtoDatabase($com->email);
      }  
        
      // Only process if not already..
      if (!$com->is_approved && !$com->is_active) {
        // Update status of comment..
        $MGA_COMMENTS->updateCommentStatus($com->id,($SETTINGS->approve ? '1' : '0'),($SETTINGS->approve ? '0' : '1'));
        $ADD_MSG = str_replace(array('{name}','{email}'),array(cleanData($com->name),$com->email),($SETTINGS->approve ? $msg_comment16.$msg_comment17 : $msg_comment16.$msg_comment18));
        
        // Get image data..
        $img    = getImageData($com->imageID);
        
        // Pass data to mail class..
        $MGA_MAIL->addTag('{NAME}', $com->name);
        $MGA_MAIL->addTag('{PIC_NAME}', $img->name);
        $MGA_MAIL->addTag('{PIC_URL}', ($SETTINGS->modr ? 'picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&picture='.$img->id));
        $MGA_MAIL->addTag('{COMMENTS}', $com->comments);
        $MGA_MAIL->addTag('{IP}', $_SERVER['REMOTE_ADDR']);
        $MGA_MAIL->addTag('{DATE}', date($SETTINGS->date_format));
        
        // Send mail to webmaster..
        $MGA_MAIL->sendMail($SETTINGS->website,
                            $SETTINGS->email,
                            $com->name,
                            $com->email,
                            '['.$SETTINGS->website.'] '.$msg_comment11,
                            $MGA_MAIL->template('themes/email/comments_added.txt')
                            );
                            
        // Send mail to visitor if enabled..
        if (COMMENT_AUTO_RESPONDER) {
          $MGA_MAIL->sendMail($com->name,
                              $com->email,
                              $SETTINGS->website,
                              $SETTINGS->email,
                              '['.$SETTINGS->website.'] '.$msg_comment12,
                              $MGA_MAIL->template('themes/email/comments_thanks.txt')
                              );
        }
        
        $VERIFIED = true;
      } else {
        $errorLoad = true;
      }
    } else {
      $errorLoad = true;
    }
    
    // Error?
    if (isset($errorLoad)) {
      include(FOLDER_PATH.'inc/header.php');
      showPageMessage($msg_comment15);
      include(FOLDER_PATH.'inc/footer.php');
      exit;
    }
  }
  
  // Security check on id..
  if (!isset($_GET['picture'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
  }
  
  checkDigit($_GET['picture']);
  
  // Get picture/category data..
  $img    = getImageData($_GET['picture']);
  $cat    = getCategoryData($img->cat);
  $title  = $msg_comment.': '.cleanData($img->name).' - '.cleanData($cat->catname);
  
  // Are comments enabled for this category? Lets double check..
  if (!$SETTINGS->comments || !$cat->en_comments) {
    echo $msg_comment4;
    exit;
  }
  
  // Get actual dimensions of image, but only if image exists..
  if (file_exists('galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->thumbpath)) {
    $size = getimagesize('galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->thumbpath);
  }
  
  // Add comment..
  if (isset($_POST['process']))
  {
    // Apply call back element to trim post vars and clear nasty tags.. 
    $_POST = array_map('cleanEvilTags',$_POST);
    
    if ($_POST['name']=='') {
      $N_ERROR = true;
      $count++;
    }
    if (!preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i", $_POST['email'])) {
      $E_ERROR = $msg_contact12;
      $count++;
    }
    if (!isset($_ERROR) && $_POST['email'] && $MGA_COMMENTS->isEmailBanned($_POST['email'])) {
      $E_ERROR = $msg_comment7;
      $count++;
    }
    if ($_POST['comments']=='') {
      $C_ERROR = true;
      $count++;
    }
    if ($SETTINGS->captcha && isset($_POST['code'])) {
      if (!chk_crypt($_POST['code'])) {
       $SUM_ERROR = true;
       $count++;
      }
    }
               
    if ($count==0) {
      // Generate verification key..
      $key = $img->id.'-'.$MGA_COMMENTS->random_data((50-strlen($img->id)-1));
      
      // Pass data to mail class..
      $MGA_MAIL->addTag('{NAME}', $_POST['name']);
      $MGA_MAIL->addTag('{PIC_NAME}', $img->name);
      $MGA_MAIL->addTag('{PIC_URL}', ($SETTINGS->modr ? 'picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&picture='.$img->id));
      $MGA_MAIL->addTag('{VERIFY_URL}', ($SETTINGS->modr ? 'verify/'.$key.'/index.html' : 'index.php?cmd=verify&code='.$key));
      $MGA_MAIL->addTag('{COMMENTS}', $_POST['comments']);
      $MGA_MAIL->addTag('{IP}', $_SERVER['REMOTE_ADDR']);
      $MGA_MAIL->addTag('{DATE}', date($SETTINGS->date_format));
      
      // Is e-mail verification required? This option overwrites all others..
      if ($SETTINGS->verification && !$MGA_COMMENTS->isEmailVerified($_POST['email'])) {
        // Add comments..
        $MGA_COMMENTS->addCommentsToDatabase($_POST,($SETTINGS->approve ? 1 : 0),
                                             0,$key,$img->id,$cat->id);
        
        // Send mail..
        $MGA_MAIL->sendMail($_POST['name'],
                            $_POST['email'],
                            $SETTINGS->website,
                            $SETTINGS->email,
                            '['.$SETTINGS->website.'] '.$msg_comment8,
                            $MGA_MAIL->template('themes/email/email_verification.txt')
                            );
                            
        $ADD_MSG = str_replace(array('{name}','{email}'),array(cleanData($_POST['name']),$_POST['email']),$msg_comment9);                    
      } else {
        // Add comments..
        $MGA_COMMENTS->addCommentsToDatabase($_POST,($SETTINGS->approve ? 1 : 0),($SETTINGS->approve ? 0 : 1),$key,$img->id,$cat->id);
        $ADD_MSG = str_replace(array('{name}','{email}'),array(cleanData($_POST['name']),$_POST['email']),($SETTINGS->approve ? $msg_comment10 : $msg_comment13));
        
        // Send mail to webmaster..
        $MGA_MAIL->sendMail($SETTINGS->website,
                            $SETTINGS->email,
                            $_POST['name'],
                            $_POST['email'],
                            '['.$SETTINGS->website.'] '.$msg_comment11,
                            $MGA_MAIL->template('themes/email/comments_added.txt')
                            );
                            
        // Send mail to visitor if enabled..
        if (COMMENT_AUTO_RESPONDER) {
          $MGA_MAIL->sendMail($_POST['name'],
                              $_POST['email'],
                              $SETTINGS->website,
                              $SETTINGS->email,
                              '['.$SETTINGS->website.'] '.$msg_comment12,
                              $MGA_MAIL->template('themes/email/comments_thanks.txt')
                              );
        }
      }
      
      $ADDED = true;
    }
  }
  
  // Parse return url..
  // This only loads if comments are left or e-mail is verified..
  $return_url = str_replace("{url}",
                            ($SETTINGS->modr ? 'picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&picture='.$img->id),
                            $msg_comment14
                            );
                          
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_comments = new Savant2();
  $tpl_comments->assign('MESSAGE',$msg_comment2);
  $tpl_comments->assign('ALL_FIELDS_REQUIRED',$msg_contact2);
  $tpl_comments->assign('HOME_URL',($SETTINGS->modr ? 'index.html' : 'index.php'));
  $tpl_comments->assign('FORM_URL',($SETTINGS->modr ? 'comment/'.$_GET['picture'].'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=leave-comment&amp;picture='.$_GET['picture']));
  $tpl_comments->assign('CATEGORIES',$msg_adminmenu4);
  $tpl_comments->assign('CAT_URL',($SETTINGS->modr ? 'category/'.(!$cat->parent ? $cat->child : $cat->id).'/'.addTitleToUrl($cat->catname).'/index.html' : 'index.php?cmd=category&amp;category='.$cat->id));
  $tpl_comments->assign('CATEGORIES_TEXT',getCategoryName((!$cat->parent ? $cat->child : $cat->id)));
  $tpl_comments->assign('IMAGE_INFO_TEXT',$msg_comment3);
  $tpl_comments->assign('COMMENTS_TEXT',$msg_pictures4.' ('.rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\'').')');
  $tpl_comments->assign('PICTURE',cleanData($img->name,IMAGE_NAME_TEXT_WRAP));
  $tpl_comments->assign('BIG_WINDOW', $SETTINGS->windowsizes);
  $tpl_comments->assign('PIC_URL',($SETTINGS->modr ? 'view-picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=view-picture&amp;picture='.$img->id));
  $tpl_comments->assign('PICTURE_URL', 'galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->thumbpath);
  $tpl_comments->assign('CLICK_FOR_FULLSIZE',$msg_pictures5);
  $tpl_comments->assign('IMG_WIDTH',($SETTINGS->thumbwidth>0 ? $SETTINGS->thumbwidth : $size[0]));
  $tpl_comments->assign('IMG_HEIGHT',($SETTINGS->thumbheight>0 ? $SETTINGS->thumbheight : $size[1]));
  if ($cmd=='leave-comment') {
  $tpl_comments->assign('NAME_TEXT', $msg_contact3);
  $tpl_comments->assign('EMAIL_TEXT', $msg_comment6);
  $tpl_comments->assign('COMMENT_TEXT', $msg_pictures4);
  $tpl_comments->assign('NAME_VALUE', (isset($_POST['name']) ? cleanData($_POST['name']) : ''));
  $tpl_comments->assign('EMAIL_VALUE', (isset($_POST['email']) ? cleanData($_POST['email']) : ''));
  $tpl_comments->assign('COMMENT_VALUE', (isset($_POST['comments']) ? cleanData($_POST['comments']) : ''));
  $tpl_comments->assign('CAPTCHA',showCaptcha((isset($SUM_ERROR) ? '<span class="error">'.$msg_contact15.'</span>' : ''),3,false));
  $tpl_comments->assign('N_ERROR', (isset($N_ERROR) ? '<span class="error">'.$msg_contact11.'</span>' : ''));
  $tpl_comments->assign('E_ERROR', (isset($E_ERROR) ? '<span class="error">'.$E_ERROR.'</span>' : ''));
  $tpl_comments->assign('C_ERROR', (isset($C_ERROR) ? '<span class="error">'.$msg_contact14.'</span>' : ''));
  $tpl_comments->assign('SPAM_ERROR', (isset($S_ERROR) ? '<span class="error">'.$msg_contact13.'</span>' : ''));
  $tpl_comments->assign('SEND_TEXT', $msg_comment5);
  $tpl_comments->assign('CANCEL', $msg_script28);
  $tpl_comments->assign('CANCEL_URL', ($SETTINGS->modr ? 'picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&amp;picture='.$img->id));
  }
  $tpl_comments->assign('COMMENTS',($SETTINGS->comments && $cat->en_comments ? (rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\'')>0 ? loadImageComments($_GET['picture'],$limitvalue,$SETTINGS->comthumbpage) : str_replace("{msg}",$msg_pictures15,file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/no_comments.tpl'))) : str_replace("{msg}",$msg_pictures16,file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/no_comments.tpl'))));
  $tpl_comments->assign('COMMENT_PAGE_NUMBERS',($SETTINGS->comments && $cat->en_comments && rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\'')>0 ? page_numbers(rowCount('comments',' WHERE imageID = \''.$_GET['picture'].'\' AND is_active = \'1\' AND is_approved = \'0\''),$SETTINGS->comthumbpage,$page,($SETTINGS->modr ? 'picture/'.$_GET['picture'].'/{page}/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&amp;picture='.$_GET['picture'].'&amp;page={page}'),'page_numbers_comments') : ''));
  $tpl_comments->assign('PROCESS_MESSAGE',(isset($ADD_MSG) ? str_replace("{msg}",$ADD_MSG,file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/message.tpl')).$return_url : ''));
  $tpl_comments->assign('DIV_DISPLAY',(isset($ADDED) || isset($VERIFIED) ? ' style="display:none"' : ' style="padding:5px"'));
  $tpl_comments->display('themes/'.$theme.'/leave_comment.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Slideshow..
  case 'slideshow':
  
  // Security check on id..
  if (!isset($_GET['category'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
  }
  
  checkDigit($_GET['category']);
  
  $cat    = getCategoryData($_GET['category']);
  $title  = $msg_slideshow.': '.cleanData($cat->catname);
  $music  = '';
  $pics   = '';
  
  // Are slideshows enabled for this category? Lets double check..
  if (!$SETTINGS->slideshow || !$cat->en_slideshow) {
    echo $msg_category8;
    exit;
  }
  
  // Are we playing music..
  // Category overwrites default..
  if ($SETTINGS->mp3!='none' || $cat->mp3!='none') {
    $music = '<script type="text/javascript" src="themes/'.$theme.'/js/mp3.js.php?file='.($cat->mp3 ? $cat->mp3 : $SETTINGS->mp3).'"></script>';
  }

  $tpl_slideshow = new Savant2();
  $tpl_slideshow->assign('CHARSET',$msg_slideshow2);
  $tpl_slideshow->assign('TITLE',$title);
  $tpl_slideshow->assign('BASE_HREF',$SETTINGS->folder);
  $tpl_slideshow->assign('THEME',$theme);
  $tpl_slideshow->assign('DELAY',$MGA_SLIDESHOW->getSlideshowSpeed($SETTINGS,(isset($_GET['speed']) ? ($_GET['speed']-1) : DEFAULT_SLIDESHOW_SPEED)));
  $tpl_slideshow->assign('LOADING_TEXT',str_replace("'","\'",$msg_slideshow4));
  $tpl_slideshow->assign('PICTURE_TEXT',str_replace("'","\'",$msg_slideshow5));
  $tpl_slideshow->assign('TEXT',$msg_slideshow3);
  $tpl_slideshow->assign('MUSIC',$music);
  $tpl_slideshow->assign('SLOW',$msg_slideshow6);
  $tpl_slideshow->assign('FAST',$msg_slideshow7);
  $tpl_slideshow->assign('FASTER',$msg_slideshow8);
  $tpl_slideshow->assign('CURRENT',(isset($_GET['speed']) && $_GET['speed']=='1' ? 'cur_button_text' : (!isset($_GET['speed']) && DEFAULT_SLIDESHOW_SPEED=='0' ? 'cur_button_text' : 'button_text')));
  $tpl_slideshow->assign('CURRENT2',(isset($_GET['speed']) && $_GET['speed']=='2' ? 'cur_button_text' : (!isset($_GET['speed']) && DEFAULT_SLIDESHOW_SPEED=='1' ? 'cur_button_text' : 'button_text')));
  $tpl_slideshow->assign('CURRENT3',(isset($_GET['speed']) && $_GET['speed']=='3' ? 'cur_button_text' : (!isset($_GET['speed']) && DEFAULT_SLIDESHOW_SPEED=='2' ? 'cur_button_text' : 'button_text')));
  $tpl_slideshow->assign('F_URL',($SETTINGS->modr ? 'slideshow/'.$_GET['category'].'/1/'.addTitleToUrl(getCategoryName($_GET['category'])).'/index.html' : 'index.php?cmd=slideshow&amp;category='.$_GET['category'].'&amp;speed=1'));
  $tpl_slideshow->assign('F_URL2',($SETTINGS->modr ? 'slideshow/'.$_GET['category'].'/2/'.addTitleToUrl(getCategoryName($_GET['category'])).'/index.html' : 'index.php?cmd=slideshow&amp;category='.$_GET['category'].'&amp;speed=2'));
  $tpl_slideshow->assign('F_URL3',($SETTINGS->modr ? 'slideshow/'.$_GET['category'].'/3/'.addTitleToUrl(getCategoryName($_GET['category'])).'/index.html' : 'index.php?cmd=slideshow&amp;category='.$_GET['category'].'&amp;speed=3'));
  $tpl_slideshow->assign('PICTURES',$MGA_SLIDESHOW->getImagesForSlideshow(FOLDER_PATH,$theme,$_GET['category'],$SETTINGS));
  $tpl_slideshow->display('themes/'.$theme.'/slideshow.tpl.php');
  
  break;
  
  // Watermark..
  case 'watermark':
  
  // Security check on id..
  if (!isset($_GET['picture'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
  }
  
  checkDigit($_GET['picture']);
  
  // Get picture/category data..
  $img  = getImageData($_GET['picture']);
  $cat  = getCategoryData($img->cat);
  
  $MGA_WMARK->waterMarkText  = ($SETTINGS->watertext ? cleanData($SETTINGS->watertext) : $msg_script32);
  $MGA_WMARK->imagePath      = 'galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->imagepath;
  $MGA_WMARK->font           = FOLDER_PATH.'classes/fonts/'.$SETTINGS->waterfont.'.ttf';
  $MGA_WMARK->size           = $SETTINGS->watersize;
  $MGA_WMARK->red            = $SETTINGS->watertextr;
  $MGA_WMARK->green          = $SETTINGS->watertextg;
  $MGA_WMARK->blue           = $SETTINGS->watertextb;
  $MGA_WMARK->hSpacing       = $SETTINGS->waterhspace;
  $MGA_WMARK->vSpacing       = $SETTINGS->watervspace;
  $MGA_WMARK->angle          = $SETTINGS->waterangle;

  header("Content-type: image/jpeg");
  
  $MGA_WMARK->mark();
  echo $MGA_WMARK->imageResource;
  
  break;
  
  // Contact..
  case 'contact':
  
  // Process form..
  if (isset($_POST['process']))
  {
    // Apply call back element to trim post vars and clear nasty tags..
    $_POST = array_map('cleanEvilTags',$_POST);
               
    if ($_POST['name']=='') {
      $N_ERROR = true;
      $count++;
    }
    if (!preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i", $_POST['email'])) {
      $E_ERROR = true;
      $count++;
    }
    if ($_POST['subject']=='') {
      $S_ERROR = true;
      $count++;
    }
    if ($_POST['comments']=='') {
      $C_ERROR = true;
      $count++;
    }
    if ($SETTINGS->captcha && isset($_POST['code'])) {
      if (!chk_crypt($_POST['code'])) {
       $SUM_ERROR = true;
       $count++;
      }
    }
               
    if ($count==0) {
      $MGA_MAIL->addTag('{NAME}',$_POST['name']);
      $MGA_MAIL->addTag('{EMAIL}',$_POST['email']);
      $MGA_MAIL->addTag('{COMMENTS}',$_POST['comments']);
      $MGA_MAIL->addTag('{IP}',$_SERVER['REMOTE_ADDR']);
       
      // Send to webmaster..
      $MGA_MAIL->sendMail($SETTINGS->website,
                          $SETTINGS->email,
                          $SETTINGS->website,
                          $SETTINGS->email,
                          '['.$SETTINGS->website.'] '.$_POST['subject'],
                          $MGA_MAIL->template('themes/email/contact_message.txt')
                          );
       
      // Send auto responder..
      $MGA_MAIL->sendMail($_POST['name'],
                          $_POST['email'],
                          $SETTINGS->website,
                          $SETTINGS->email,
                          '['.$SETTINGS->website.'] '.str_replace('{subject}',$_POST['subject'],$msg_contact18),
                          $MGA_MAIL->template('themes/email/contact_auto.txt')
                          );
      
      // Clear post vars..
      $_POST['name']      = '';
      $_POST['email']     = '';
      $_POST['subject']   = '';
      $_POST['comments']  = '';
      
      $SENT = true;                    
    }
  }
  
  // Don`t show cart if ip banned..
  if (isIPAddressBanned($_SERVER['REMOTE_ADDR'])) {
    $banned = true;
  }
  
  $title = $msg_header3;
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_contact = new Savant2();
  $tpl_contact->assign('MESSAGE',$msg_contact);
  $tpl_contact->assign('REQUIRED',(isset($SENT) ? $msg_contact17 : ($count>0 ? str_replace("{count}",$count,$msg_contact16) : $msg_contact2)));
  $tpl_contact->assign('MESSAGE_SENT',$msg_contact19);
  $tpl_contact->assign('CONTACT_TXT', $msg_header3);
  $tpl_contact->assign('IS_SENT',(isset($SENT) ? true : false));
  $tpl_contact->assign('FORM_ACTION',($SETTINGS->modr ? 'contact.html' : 'index.php?cmd=contact'));
  $tpl_contact->assign('NAME_TEXT', $msg_contact3);
  $tpl_contact->assign('EMAIL_TEXT', $msg_contact4);
  $tpl_contact->assign('SUBJECT_TEXT', $msg_contact5);
  $tpl_contact->assign('COMMENT_TEXT', $msg_contact6);
  $tpl_contact->assign('NAME_VALUE', (isset($_POST['name']) ? cleanData($_POST['name']) : ''));
  $tpl_contact->assign('EMAIL_VALUE', (isset($_POST['email']) ? cleanData($_POST['email']) : ''));
  $tpl_contact->assign('SUBJECT_VALUE', (isset($_POST['subject']) ? cleanData($_POST['subject']) : ''));
  $tpl_contact->assign('COMMENT_VALUE', (isset($_POST['comments']) ? cleanData($_POST['comments']) : ''));
  $tpl_contact->assign('CAPTCHA',showCaptcha((isset($SUM_ERROR) ? '<span class="error">'.$msg_contact15.'</span>' : ''),1,true));
  $tpl_contact->assign('N_ERROR', (isset($N_ERROR) ? '<span class="error">'.$msg_contact11.'</span>' : ''));
  $tpl_contact->assign('E_ERROR', (isset($E_ERROR) ? '<span class="error">'.$msg_contact12.'</span>' : ''));
  $tpl_contact->assign('S_ERROR', (isset($S_ERROR) ? '<span class="error">'.$msg_contact13.'</span>' : ''));
  $tpl_contact->assign('C_ERROR', (isset($C_ERROR) ? '<span class="error">'.$msg_contact14.'</span>' : ''));
  $tpl_contact->assign('SEND_TEXT', $msg_contact7);
  $tpl_contact->display('themes/'.$theme.'/contact.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // About..
  case 'about':
  
  $title = $msg_header4;
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_about = new Savant2();
  $tpl_about->assign('MESSAGE',$msg_about);
  $tpl_about->assign('HEAD_MESSAGE',$msg_header4);
  $tpl_about->assign('ABOUT_TEXT',nl2br(cleanData($SETTINGS->aboutsite)));
  $tpl_about->display('themes/'.$theme.'/about.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Licence..
  case 'licence':
  
  $title = $msg_header8;
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_licence = new Savant2();
  $tpl_licence->assign('MESSAGE',$msg_licence);
  $tpl_licence->assign('HEAD_MESSAGE',$msg_header8);
  $tpl_licence->assign('LICENCE_TEXT',nl2br(cleanData($SETTINGS->licence)));
  $tpl_licence->display('themes/'.$theme.'/licence.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Question..
  case 'ask-question':
  
  // Security check on id..
  if (!isset($_GET['picture'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
  }
  
  checkDigit($_GET['picture']);
  
  // Get picture/category data..
  $img  = getImageData($_GET['picture']);
  $cat  = getCategoryData($img->cat);
  
  // Process question..
  if (isset($_POST['process']))
  {
    // Apply call back element to trim post vars and clear nasty tags..
    $_POST = array_map('cleanEvilTags',$_POST);
               
    if ($_POST['name']=='') {
      $N_ERROR = true;
      $count++;
    }
    if (!preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i", $_POST['email'])) {
      $E_ERROR = true;
      $count++;
    }
    if ($_POST['comments']=='') {
      $C_ERROR = true;
      $count++;
    }
    if ($SETTINGS->captcha && isset($_POST['code'])) {
      if (!chk_crypt($_POST['code'])) {
       $SUM_ERROR = true;
       $count++;
      }
    }
               
    if ($count==0) {
      $MGA_MAIL->addTag('{NAME}',$_POST['name']);
      $MGA_MAIL->addTag('{EMAIL}',$_POST['email']);
      $MGA_MAIL->addTag('{COMMENTS}',$_POST['comments']);
      $MGA_MAIL->addTag('{IP}',$_SERVER['REMOTE_ADDR']);
      $MGA_MAIL->addTag('{PIC_NAME}',$img->name);
      $MGA_MAIL->addTag('{PIC_URL}',($SETTINGS->modr ? 'picture/'.$_GET['picture'].'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&picture='.$_GET['picture']));
       
      // Send to webmaster..
      $MGA_MAIL->sendMail($SETTINGS->website,
                          $SETTINGS->email,
                          $SETTINGS->website,
                          $SETTINGS->email,
                          '['.$SETTINGS->website.'] '.$msg_question3,
                          $MGA_MAIL->template('themes/email/question_webmaster.txt')
                          );
       
      // Send auto responder..
      $MGA_MAIL->sendMail($_POST['name'],
                          $_POST['email'],
                          $SETTINGS->website,
                          $SETTINGS->email,
                          '['.$SETTINGS->website.'] '.$msg_question5,
                          $MGA_MAIL->template('themes/email/question_auto.txt')
                          );
      
      // Clear post vars..
      $_POST['name']      = '';
      $_POST['email']     = '';
      $_POST['comments']  = '';
      
      $SENT = true;                    
    }
  }
  
  $tpl_question = new Savant2();
  $tpl_question->assign('CHARSET', $msg_charset);
  $tpl_question->assign('TITLE', $msg_pictures10);
  $tpl_question->assign('BASE_HREF', $SETTINGS->folder);
  $tpl_question->assign('THEME',$theme);
  $tpl_question->assign('URL',($SETTINGS->modr ? 'question/'.$_GET['picture'].'/index.html' : 'index.php?cmd=ask-question&amp;picture='.$_GET['picture']));
  $tpl_question->assign('NAME_TEXT', $msg_contact3);
  $tpl_question->assign('EMAIL_TEXT', $msg_contact4);
  $tpl_question->assign('COMMENT_TEXT', $msg_contact6);
  $tpl_question->assign('NAME_VALUE', (isset($_POST['name']) ? cleanData($_POST['name']) : ''));
  $tpl_question->assign('EMAIL_VALUE', (isset($_POST['email']) ? cleanData($_POST['email']) : ''));
  $tpl_question->assign('COMMENT_VALUE', (isset($_POST['comments']) ? cleanData($_POST['comments']) : str_replace('{picture}',cleanData($img->name),$msg_question4)));
  $tpl_question->assign('CAPTCHA',showCaptcha((isset($SUM_ERROR) ? '<span class="error">'.$msg_contact15.'</span>' : ''),2,false));
  $tpl_question->assign('N_ERROR', (isset($N_ERROR) ? '<span class="error">'.$msg_contact11.'</span>' : ''));
  $tpl_question->assign('E_ERROR', (isset($E_ERROR) ? '<span class="error">'.$msg_contact12.'</span>' : ''));
  $tpl_question->assign('S_ERROR', (isset($S_ERROR) ? '<span class="error">'.$msg_contact13.'</span>' : ''));
  $tpl_question->assign('C_ERROR', (isset($C_ERROR) ? '<span class="error">'.$msg_contact14.'</span>' : ''));
  $tpl_question->assign('SEND_TEXT', $msg_contact7);
  $tpl_question->assign('DIV_1',(isset($SENT) ? ' style="display:none"' : ''));
  $tpl_question->assign('DIV_2',(!isset($SENT) ? ' style="display:none"' : ''));
  $tpl_question->assign('THANKS',$msg_question);
  $tpl_question->assign('PATH', $SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->thumbpath);
  $tpl_question->assign('MESSAGE',$msg_question2);
  $tpl_question->assign('IMG_NAME',cleanData($img->name));
  $tpl_question->display('themes/'.$theme.'/ask_question.tpl.php');
  
  break;
  
  // Search..
  case 'search':
  case 'advanced-search':
  
  $SQL            = '';
  $searchResults  = '';
  $string         = '';
  
  // If advanced search link has been pressed and we haven`t come from a category
  //   page, lets clear the session var set by the category pages..
  if (isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'],'category')===FALSE && isset($_SESSION['av_search_category'])) {
    unset($_SESSION['av_search_category']);
  }
  
  
  if (isset($_GET['search_type'])) {
    // No keywords at this point? Invalid page..
    if (!isset($_GET['keywords'])) {
      header("HTTP/1.0 404 Not Found");
      exit;
    }
    
    // Are there keywords?
    // A blank box is pointless so just direct to homepage..
    // No point showing messages for the button click fetishists. :p
    if (cleanEvilTags($_GET['keywords'])) {
      $words = explode(" ", cleanEvilTags($_GET['keywords']));
    
      $startTime = executionTime();
      
      // Check all GET vars..
      $name      = (isset($_GET['name']) && in_array($_GET['name'],array('0','1')) ? true : false); 
      $comments  = (isset($_GET['comments']) && in_array($_GET['comments'],array('0','1')) ? true : false); 
      $match     = (isset($_GET['match']) && in_array($_GET['match'],array('partial','exact')) ? $_GET['match'] : 'partial');
        
      // Enable comment and name vars if both false..
      if (!$name && !$comments) {
        $name      = true;
        $comments  = true;
      }  
      
      for ($i=0; $i<count($words); $i++) {
        switch ($match) {
          case 'partial':
          $SQL .= ($i ? 
                   'OR '.($name ? 'name' : 'comments').' LIKE \'%'.mysql_real_escape_string($words[$i]).'%\' OR '.($comments ? 'comments' : 'name').' LIKE \'%'.mysql_real_escape_string($words[$i]).'%\'' :
                   'WHERE ('.($name ? 'name' : 'comments').' LIKE \'%'.mysql_real_escape_string($words[$i]).'%\' OR '.($comments ? 'comments' : 'name').' LIKE \'%'.mysql_real_escape_string($words[$i]).'%\''
                   ); 
          break;  
          case 'exact':
          $SQL .= ($i ? 
                   'OR '.($name ? 'name' : 'comments').' = \''.mysql_real_escape_string($words[$i]).'\' OR '.($comments ? 'comments' : 'name').' = \''.mysql_real_escape_string($words[$i]).'\'' :
                   'WHERE ('.($name ? 'name' : 'comments').' = \''.mysql_real_escape_string($words[$i]).'\' OR '.($comments ? 'comments' : 'name').' = \''.mysql_real_escape_string($words[$i]).'\''
                   ); 
          break;        
        }
      }
      
      // Determine syntax based on search type..
      // 1 = Standard Search
      // 2 = Advanced Search
      switch ($_GET['search_type']) {
        case '1':
        $SQL .= ')';
        break;
      
        case '2':
        
        // Set up some default first to prevent errors..
        // Also checks all GET vars coming in..
        // Prevents someone changing the data..
        $cat    = (isset($_GET['cat']) && ctype_digit($_GET['cat']) ? $_GET['cat'] : '0');
        $order  = (isset($_GET['order']) && in_array($_GET['order'],array('name','id_asc','id_asc')) ? $_GET['order'] : 'name');
        
        // Check dates..
        if ($_GET['from']) {
          $from_array  = explode("-",$_GET['from']);
          $check_from  = (isset($from_array[0]) && (isset($from_array[1]) && isset($from_array[2])) ? true : false);
        }
        if ($_GET['to']) {
          $to_array    = explode("-",$_GET['from']);
          $check_to    = (isset($to_array[0]) && (isset($to_array[1]) && isset($to_array[2])) ? true : false);
        }
        $from  = ($_GET['from'] && checkdate($from_array[1],$from_array[2],$from_array[0]) ? $_GET['from'] : '');
        $to    = ($_GET['to'] && checkdate($to_array[1],$to_array[2],$to_array[0]) ? $_GET['to'] : '');
        
        // Now build additional syntax for advanced search..
        $SQL .= ')';
        $SQL .= ($cat>0 ? " AND cat = '{$cat}' " : "");
        $SQL .= ($from && $to ? " AND addDate BETWEEN '{$from}' AND '{$to}' " : "");
        
        // Order by adjustment..
        if ($order!='name') {
          $order = ($order=='id_asc' ? 'id ASC' : 'id DESC');
        }
        
        break;
      }
      
      // Search count..
      $q_search_count = mysql_query("SELECT count(*) AS s_count FROM ".$database['prefix']."images
                                     $SQL
                                     ") or die(mysql_error());
      $COUNT = mysql_fetch_object($q_search_count);
    
      // Get data..
      $q_search = mysql_query("SELECT * FROM ".$database['prefix']."images
                               $SQL
                               ORDER BY ".(isset($order) ? $order : 'name')."
                               LIMIT $limitvalue,$limit
                               ") or die(mysql_error());
    
      // Loop through results..
      if (mysql_num_rows($q_search)>0) {
        while ($SEARCH = mysql_fetch_object($q_search)) {
          $i_url = ($SETTINGS->modr ? 'picture/'.$SEARCH->id.'/'.addTitleToUrl(getCategoryName($SEARCH->cat)).'/'.addTitleToUrl($SEARCH->name).'.html' : 'index.php?cmd=pictures&amp;picture='.$SEARCH->id);
          $string .= '<li><a href="'.$i_url.'"><img src="galleries/'.$SETTINGS->folder_name.'/'.getFolderName($SEARCH->cat).'/'.$SEARCH->thumbpath.'" '.($SETTINGS->thumbwidth>0 ? 'width="'.$SETTINGS->thumbwidth.'"' : '').' '.($SETTINGS->thumbheight>0 ? 'height="'.$SETTINGS->thumbheight.'"' : '').' alt="'.cleanData($SEARCH->name).'" title="'.cleanData($SEARCH->name).'" class="thumbnail" /></a><span class="catname">'.cleanData($SEARCH->name,IMAGE_NAME_TEXT_WRAP).'</span></li>'."\n";
        }
        // Parse string..
        $searchResults = str_replace("{pictures}",$string,
                                     file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/pictures.tpl')
                                     );
      } else {
        // Parse string for no results..
        $searchResults = str_replace("{text}",str_replace("{keywords}",cleanEvilTags($_GET['keywords']),$msg_publicsearch),
                                     file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/no_search_results.tpl')
                                     );
      }
    
      $endTime      = executionTime();
     $showResults  = true;
    
    } else {
      if ($cmd=='search') {
        header("Location: ".($SETTINGS->modr ? ($cmd=='search' ? 'index.html' : 'advanced-search.html') : ($cmd=='search' ? 'index.php' : 'index.php?cmd=advanced-search'))."");
      } else {
        $K_ERROR = true;
      }
    }
  }
  
  $title = isset($showResults) ? $msg_publicsearch23 : $msg_header9;
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_search = new Savant2();
  if (isset($showResults)) {
  $tpl_search->assign('INTRO',$msg_publicsearch3);
  $tpl_search->assign('SEARCH_TEXT',str_replace("{count}",number_format($COUNT->s_count),$msg_publicsearch2));
  $tpl_search->assign('SEARCH_RESULTS',$searchResults);
  $tpl_search->assign('SEARCH_RES',$msg_publicsearch23);
  $tpl_search->assign('PAGE_NUMBERS',($COUNT->s_count>0 ? page_numbers($COUNT->s_count,$SETTINGS->thumbpage,$page,($SETTINGS->modr ? 'index.html?' : 'index.php?').searchQueryString().'&amp;page={page}') : ''));
  $tpl_search->assign('STATS',str_replace("{seconds}",number_format($endTime-$startTime,4),$msg_publicsearch4));
  } else {
  $tpl_search->assign('INTRO',$msg_publicsearch5);
  $tpl_search->assign('SEARCH_TEXT',$msg_publicsearch6);
  $tpl_search->assign('SELECT_TXT',$msg_publicsearch24);
  $tpl_search->assign('KEYWORDS_TEXT',$msg_publicsearch7);
  $tpl_search->assign('KEYWORDS_VALUE',(isset($_GET['keywords']) && $_GET['keywords'] ? cleanEvilTags($_GET['keywords']) : (isset($K_ERROR) ? $msg_publicsearch8 : '')));
  $tpl_search->assign('H_URL', ($SETTINGS->modr ? 'index.html' : 'index.php'));
  $tpl_search->assign('CATEGORY_TEXT',$msg_publicsearch10);
  $tpl_search->assign('ALL_CATEGORIES_TEXT',$msg_publicsearch9);
  $tpl_search->assign('MATCH_TEXT',$msg_publicsearch11);
  $tpl_search->assign('EXACT_TEXT',$msg_publicsearch12);
  $tpl_search->assign('PARTIAL_TEXT',$msg_publicsearch13);
  $tpl_search->assign('CATEGORIES',showCategories());
  $tpl_search->assign('AREA_TEXT',$msg_publicsearch14);
  $tpl_search->assign('NAME_TEXT',$msg_publicsearch16);
  $tpl_search->assign('COMMENTS_TEXT',$msg_publicsearch15);
  $tpl_search->assign('SEARCH',$msg_publicsearch17);
  $tpl_search->assign('DATE_TEXT',$msg_publicsearch18);
  $tpl_search->assign('ORDER_TEXT',$msg_publicsearch19);
  $tpl_search->assign('ORDER_OLDEST',$msg_publicsearch20);
  $tpl_search->assign('ORDER_NEWEST',$msg_publicsearch21);
  $tpl_search->assign('ORDER_NAME',$msg_publicsearch22);
  }
  $tpl_search->display('themes/'.$theme.'/'.(isset($showResults) ? 'search' : 'advanced_search').'.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Cart Processing..
  case 'add-to-cart':
  case 'clear-cart':
  case 'cart':
  case 'delete-cart-item':
  
  switch ($cmd) {
    // Add pictures to cart..
    case 'add-to-cart':
    
    $url = ($SETTINGS->modr ? 'index.html' : 'index.php');
    
    if (isset($_POST['process'])) {
      for ($i=0; $i<count($_POST['id']); $i++) {
        // Set url path so we direct back to same picture page..
        // Only parse this once..
        if (!$i) {
          $split  = explode("-",$_POST['id'][$i]);
          $img    = getImageData($split[0]);
          $url    = ($SETTINGS->modr ? 'picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&picture='.$img->id);
        }
        // Next, add to cart only pictures where the quantity was greater than 0..
        if ($_POST['qty'][$i]>0) {
          $MGA_CART->addToCart($_POST['id'][$i],$_POST['size'][$i],$_POST['cost'][$i],
                               $_POST['item'][$i],ceil($_POST['qty'][$i])
                               );
        }
      }
    }
    
    header("Location: $url");
    exit;
    break;
    
    // Clear cart..
    case 'clear-cart':
    $MGA_CART->clearCart();
    header("Location: ".($SETTINGS->modr ? 'view-cart.html' : 'index.php?cmd=view-cart')."");
    exit;
    break;
    
    // Update cart..
    case 'cart':
    
    if (isset($_POST['process'])) {
      // Loop through and update items..
      // If quantity set to 0, remove slot..
      for($i=0; $i<count($_POST['id']); $i++) {
        // Only update if quantity is different.
        if($_POST['qty'][$i]>0) {
          // Get current slot data and load in array..
          // $cartInfo[0] = ID
          // $cartInfo[1] = Size
          // $cartInfo[2] = Cost
          // $cartInfo[3] = Item No
          // $cartInfo[4] = Qty
          // $cartInfo[5] = Code
          // $cartInfo[6] = Single Price
          $cartInfo = $MGA_CART->getCartSessionData($i);
          // Now update slot..
          $MGA_CART->updateSessionSlot($i,$cartInfo,ceil($_POST['qty'][$i]));
        } else {
          $MGA_CART->clearSessionSlot($i);
        }
      }
    }
    
    header("Location: ".($SETTINGS->modr ? $SETTINGS->folder.'/view-cart.html' : $SETTINGS->folder.'/index.php?cmd=view-cart')."");
    exit;
    
    break;
    
    // Delete cart item..
    case 'delete-cart-item':
    $MGA_CART->deleteCartItem($_GET['id']);
    header("Location: ".($SETTINGS->modr ? $SETTINGS->folder.'/view-cart.html' : $SETTINGS->folder.'/index.php?cmd=view-cart')."");
    exit;
    break;
  }
  
  break;
  
  // View Cart..
  case 'view-cart':
  
  // Firstly, is the cart enabled for this gallery?
  if (!$SETTINGS->cart) {
    header("Location: ".($SETTINGS->modr ? $SETTINGS->folder.'/index.html' : $SETTINGS->folder.'/index.php')."");
    exit;
  }
  
  $cartData     = '';
  $cartButtons  = '';
  
  // Does the cart have any items...
  // If not display empty cart message..
  if ($MGA_CART->cartCount()>0) {
    // Loop through cart data..
    for ($i=0; $i<count($_SESSION['pic_id']); $i++) {
      // Check key exists. If it does and its 0, ignore it..
      if (array_key_exists($i,$_SESSION['pic_id']) && $_SESSION['pic_id'][$i]!='0') {
        // Get image data..
        $split  = explode("-",$_SESSION['pic_id'][$i]);
        $img    = getImageData($split[0]);
        $cat    = getCategoryData($img->cat);
        $cartData .= str_replace(array(
                                 '{pic_path}','{thumb_path}','{pic_url}','{pic_name}','{big_window}','{size}','{item_no}','{qty_txt}',
                                 '{qty}','{total}','{delete_url}','{are_you_sure}','{delete}','{code}','{id}','{theme}'
                                 ),
                                 array(
                                 ($SETTINGS->modr ? 'view-picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=view-picture&amp;picture='.$img->id),
                                 'galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$img->thumbpath,
                                 $SETTINGS->folder.'/'.($SETTINGS->modr ? 'picture/'.$img->id.'/'.addTitleToUrl(getCategoryName($img->cat)).'/'.addTitleToUrl($img->name).'.html' : 'index.php?cmd=pictures&amp;picture='.$img->id),
                                 cleanData($img->name),
                                 $SETTINGS->windowsizes,
                                 str_replace("{size}",$_SESSION['pic_size'][$i],$msg_viewcart3),
                                 str_replace("{itemno}",($_SESSION['pic_item'][$i]!='none' ? $_SESSION['pic_item'][$i] : 'N/A'),$msg_viewcart4),
                                 $msg_viewcart5,
                                 $_SESSION['pic_qty'][$i],
                                 get_cur_symbol($_SESSION['pic_cost'][$i],$PP->ppCurrency),
                                 ($SETTINGS->modr ? 'delete-cart-item/'.$_SESSION['pic_code'][$i].'/index.html' : 'index.php?cmd=delete-cart-item&amp;id='.$_SESSION['pic_code'][$i]),
                                 $msg_javascript,
                                 $msg_viewcart6,
                                 $_SESSION['pic_code'][$i],
                                 $_SESSION['pic_id'][$i],
                                 $theme
                                 ),
                                 file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/cart_item.tpl')
                                 );
      }
    }
    $cartButtons = str_replace(array(
                               '{total_txt}','{total}','{clear_url}','{are_you_sure}','{clear}',
                               '{update}','{checkout}','{shipping_txt}','{shipping_total}','{checkout_url}','{theme}'
                               ),
                               array(
                               $msg_viewcart7,
                               get_cur_symbol($MGA_CART->cartTotal(true),$PP->ppCurrency),
                               ($SETTINGS->modr ? 'clear-cart.html' : 'index.php?cmd=clear-cart'),
                               $msg_javascript,
                               $msg_viewcart8,
                               $msg_viewcart9,
                               $msg_viewcart10,
                               $msg_viewcart11,
                               get_cur_symbol($MGA_CART->setShippingCharge(),$PP->ppCurrency),
                               ($SETTINGS->modr ? 'checkout.html' : 'index.php?cmd=checkout'),
                               $theme
                               ),
                               file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/cart_buttons.tpl')
                               );
  } else {
    // Show buttons..
    $cartData = str_replace("{text}",$msg_viewcart2,
                            file_get_contents(FOLDER_PATH.'themes/'.$theme.'/tpl_files/empty_cart.tpl')
                            );
  }
  
  $title = $msg_viewcart12;
  
  include(FOLDER_PATH.'inc/header.php');
  
  $tpl_cart = new Savant2();
  $tpl_cart->assign('MESSAGE',$msg_viewcart);
  $tpl_cart->assign('CART_TEXT',$MGA_CART->cartCount().' '.($MGA_CART->cartCount()==1 ? $msg_header6 : $msg_header7));
  $tpl_cart->assign('CART_DATA',$cartData);
  $tpl_cart->assign('CART_BUTTONS',$cartButtons);
  $tpl_cart->assign('CART_CONTENTS',$msg_viewcart13);
  $tpl_cart->assign('FORM_ACTION',($SETTINGS->modr ? 'cart.html' : 'index.php?cmd=cart'));
  $tpl_cart->display('themes/'.$theme.'/view_cart.tpl.php');
  
  include(FOLDER_PATH.'inc/footer.php');
  
  break;
  
  // Paypal processing..
  case 'notify':

  // Does post array exist..
  if (!isset($_POST)) {
   exit;
  }
  
  // Check custom var..
  // If 'maiangallery' txt isn`t present, data could be being sent from another paypal script..
  // Exit if no txt found to prevent further processing..
  // Only Maian Gallery purchases can continue..
  if (strpos($_POST['custom'],'maiangallery')===FALSE) {
   exit;
  }
  
  // Send response..
  $MGA_PAYPAL->send_response();
  
  // Explode custom var..
  // $custom[0] = Cart ID
  $custom = explode("-", $_POST['custom']);
  
  // Is transation invalid..
  // Validate response from Paypal website..
  if(!$MGA_PAYPAL->is_verified()) {
    $MGA_PAYPAL->error_out($msg_ipn);
    
    // Send mail and terminate..
    $MGA_MAIL->sendMail($com->name,
                        $com->email,
                        $SETTINGS->website,
                        $SETTINGS->email,
                        '['.$SETTINGS->website.'] '.$msg_comment12,
                        $MGA_MAIL->template('themes/email/paypal_invalid.txt')
                        );
    exit;                    
  }
  
  switch ($MGA_PAYPAL->get_payment_status()) {
    case 'Completed':
    
    // Update cart ipn data..
    $MGA_CART->updateCartPurchaseTable($_POST,$custom[0]);
    
    // Now assign tags for e-mails..
    $MGA_MAIL->addTag('{NAME}',$_POST['first_name'].' '.$_POST['last_name']);
    $MGA_MAIL->addTag('{TOTAL}',$MGA_CART->formatPrice($_POST['mc_gross']).' ('.$PP->ppCurrency.')');
    $MGA_MAIL->addTag('{INVOICE_NO}',$custom[1]);
    $MGA_MAIL->addTag('{PICTURES}',$MGA_CART->loadPurchasesIntoString($custom[0],$msg_ipn6,$msg_ipn8,$msg_ipn7));
    $MGA_MAIL->addTag('{DATE}',date("j F Y"));
    
    // Send mail to webmaster..
    $MGA_MAIL->sendMail($SETTINGS->website,
                        $SETTINGS->email,
                        $SETTINGS->website,
                        $SETTINGS->email,
                        '['.$SETTINGS->website.'] '.$msg_ipn5,
                        $MGA_MAIL->template('themes/email/purchase_admin.txt')
                        );
                        
    // Send mail to buyer..
    $MGA_MAIL->sendMail($_POST['first_name'],
                        $_POST['payer_email'],
                        $SETTINGS->website,
                        $SETTINGS->email,
                        '['.$SETTINGS->website.'] '.$msg_ipn4,
                        $MGA_MAIL->template('themes/email/purchase_auto.txt')
                        );  
                                          
    exit;
    break;

	  case 'Pending':
	  
	  // Send mail..
    $MGA_MAIL->sendMail($_POST['first_name'],
                        $_POST['payer_email'],
                        $SETTINGS->website,
                        $SETTINGS->email,
                        '['.$SETTINGS->website.'] '.$msg_ipn3,
                        $MGA_MAIL->template('themes/email/paypal_pending.txt')
                        );

    exit;

	  break;

	  case 'Failed':
	  case 'Denied':
	  $MGA_PAYPAL->error_out($msg_ipn);
    break;

	  // Not currently supported..
    case 'Refunded':
	  break;

	  default:
	  $MGA_PAYPAL->error_out($msg_ipn);
    break;
  }
  
  break;
  
  // RSS Feed..
  case 'rss-feed':
  
  $rss_feed       = '';
  $build_date     = date('D, j M Y H:i:s').' GMT';
  
  // Open channel..
  $rss_feed = $MGA_FEED->open_channel();
   
  // Feed info..
  $rss_feed .= $MGA_FEED->feed_info(str_replace("{website_name}",$SETTINGS->website,$msg_rss),
                                   ($SETTINGS->modr ? $SETTINGS->folder.'/index.html' : $SETTINGS->folder.'/index.php'),
                                   $build_date,
                                   str_replace("{website_name}",$SETTINGS->website,$msg_rss2),
                                   $SETTINGS->website
                                   );
   
  // Get latest posts..
  $query = mysql_query("SELECT * FROM ".$database['prefix']."images 
                        ORDER BY id DESC 
                        LIMIT ".RSS_FEED_TOTAL."
                        ") or die(mysql_error());

  while ($RSS = mysql_fetch_object($query)) {
    $cat       = getCategoryData($RSS->cat);
    $rss_feed .= $MGA_FEED->add_item($msg_rss3.$RSS->name.' ('.$cat->catname.')',
                                    ($SETTINGS->modr ? $SETTINGS->folder.'/picture/'.$RSS->id.'/'.addTitleToUrl(getCategoryName($RSS->cat)).'/'.addTitleToUrl($RSS->name).'.html' : $SETTINGS->folder.'/index.php?cmd=pictures&amp;picture='.$RSS->id),
                                    ($RSS->rss_date ? $RSS->rss_date : $build_date),
                                    '<img src="'.$SETTINGS->folder.'/galleries/'.$SETTINGS->folder_name.'/'.$cat->folder.'/'.$RSS->thumbpath.'" alt="'.$RSS->name.'" border="1" title="'.$RSS->name.'" />'.($RSS->comments ? '<br /><br />'.$RSS->comments : '')
                                    );
  }
   
  // Close channel..
  $rss_feed .= $MGA_FEED->close_channel();
   
  // Display RSS feed..
  header('Content-Type: text/xml');
  echo (get_magic_quotes_gpc() ? stripslashes(trim($rss_feed)) : trim($rss_feed));
  
  break;
}

?>
